// AnimationFactoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AnimationFactory.h"
#include "AnimationFactoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg dialog

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnimationFactoryDlg * g_pAnimationFactoryDlg = NULL;

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = 0;

	SC_DEBUG( "on_no_signal_detected_callback( %d )", i );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = 0;

	SC_DEBUG( "on_no_signal_removed_callback( %d )", i );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = nVideoWidth;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = nVideoHeight;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = nAudioChannels;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = nAudioBitsPerSample;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = nAudioSampleFrequency;

	SC_DEBUG( "on_format_changed_callback( %d, %d, %d, %d, %d, %d )", i, nVideoWidth, nVideoHeight, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	//ULONG i = (ULONG)(pUserData);
	//
	//EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 0 ] );

	//if( i == 0 ) { // SOURCE IS CH01

	//	if( g_pAnimationFactoryDlg->m_nShareRecordStates[ 0 ] > 0x00000000 ) {

	//		if( g_pAnimationFactoryDlg->m_hShareRecordThreadBufferReadyEvents[ 0 ] ) {

	//			SetEvent( g_pAnimationFactoryDlg->m_hShareRecordThreadBufferReadyEvents[ 0 ] );
	//		}
	//	}	
	//}
	//LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 0 ] );
	//
	//EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 1 ] );

	//if( i == 1 ) { // SOURCE IS CH01

	//	if( g_pAnimationFactoryDlg->m_nShareRecordStates[ 1 ] > 0x00000000 ) {

	//		if( g_pAnimationFactoryDlg->m_hShareRecordThreadBufferReadyEvents[ 1 ] ) {

	//			SetEvent( g_pAnimationFactoryDlg->m_hShareRecordThreadBufferReadyEvents[ 1 ] );
	//		}
	//	}	
	//}
	//LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 1 ] );

    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 0 ] );

	if( i == 0 ) { // SOURCE IS CH01

		if( g_pAnimationFactoryDlg->m_nShareRecordStates[ 0 ] > 0x00000000 ) {

			QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
		}	
	}
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 0 ] );

	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 1 ] );

	if( i == 0 ) { // SOURCE IS CH01

		if( g_pAnimationFactoryDlg->m_nShareRecordStates[ 1 ] > 0x00000000 ) {

			QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 1, pFrameBuffer, nFrameBufferLen );
		}	
	}
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 1 ] );

    return (QRETURN)(QCAP_RT_SKIP_DISPLAY | QCAP_RT_SKIP_CLONE_DISPLAY);
}

QRETURN on_video_share_record_media_timer_callback( UINT iRecNum, double dSampleTime, double dDelayTime, PVOID pUserData  )
{
	ULONG i = (ULONG)(pUserData);
	
	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 0 ] );

	if( i == 0 ) { // SOURCE IS CH01

		if( g_pAnimationFactoryDlg->m_nShareRecordStates[ 0 ] > 0x00000000 ) {

			if( g_pAnimationFactoryDlg->m_hShareRecordThreadBufferReadyEvents[ 0 ] ) {

				SetEvent( g_pAnimationFactoryDlg->m_hShareRecordThreadBufferReadyEvents[ 0 ] );
			}
		}	
	}
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 0 ] );
	
	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 1 ] );

	if( i == 1 ) { // SOURCE IS CH01

		if( g_pAnimationFactoryDlg->m_nShareRecordStates[ 1 ] > 0x00000000 ) {

			if( g_pAnimationFactoryDlg->m_hShareRecordThreadBufferReadyEvents[ 1 ] ) {

				SetEvent( g_pAnimationFactoryDlg->m_hShareRecordThreadBufferReadyEvents[ 1 ] );
			}
		}	
	}
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordStateAccessCriticalSections[ 1 ] );

	return QCAP_RT_OK;
}

DWORD WINAPI on_process_share_record( LPVOID params, ULONG i )
{
	CAnimationFactoryDlg * pAnimationFactoryDlg = (CAnimationFactoryDlg *)(params);

	HANDLE events[ 2 ] = { pAnimationFactoryDlg->m_hShareRecordThreadStopEvents[ i ], 

						   pAnimationFactoryDlg->m_hShareRecordThreadBufferReadyEvents[ i ] };

	while( TRUE ) {
		
		DWORD returns = WaitForMultipleObjects( 2, events, FALSE, INFINITE );

		if( returns == (WAIT_OBJECT_0) ) { break ; }

		if( returns == (WAIT_OBJECT_0 + 1) ) {

			UINT   iFrameNum = 0;

			BYTE * pFrameBuffer = NULL;

			ULONG  nFrameBufferLen = 0;

			QCAP_STEP_ANIMATION_CLIP( g_pAnimationFactoryDlg->m_pClips[ i ], &iFrameNum, &pFrameBuffer, &nFrameBufferLen );
			
			if( pFrameBuffer ) {

				QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( i, g_pAnimationFactoryDlg->m_nClipColorSpaceTypes[ i ], 
					
																	 g_pAnimationFactoryDlg->m_nClipWidths[ i ], 
																	 
																	 g_pAnimationFactoryDlg->m_nClipHeights[ i ], 
																	 
																	 pFrameBuffer, 
																	 
																	 nFrameBufferLen );
			}
		}
	}
	return 0;
}

DWORD WINAPI on_process_share_record_ch01( LPVOID params )
{
	return on_process_share_record( params, 0 );
}

DWORD WINAPI on_process_share_record_ch02( LPVOID params )
{
	return on_process_share_record( params, 1 );
}

CAnimationFactoryDlg::CAnimationFactoryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimationFactoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnimationFactoryDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAnimationFactoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimationFactoryDlg)
	DDX_Control(pDX, IDC_STATIC_SHARE_WINDOW_1, m_statShareWindow1);
	DDX_Control(pDX, IDC_STATIC_SHARE_WINDOW_0, m_statShareWindow0);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_5, m_statChannelWindow5);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_4, m_statChannelWindow4);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_3, m_statChannelWindow3);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_2, m_statChannelWindow2);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_1, m_statChannelWindow1);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_0, m_statChannelWindow0);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAnimationFactoryDlg, CDialog)
	//{{AFX_MSG_MAP(CAnimationFactoryDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_STATIC_CHANNEL_WINDOW_0, OnClickedChannelWindow0)
	ON_BN_CLICKED(IDC_STATIC_CHANNEL_WINDOW_1, OnClickedChannelWindow1)
	ON_BN_CLICKED(IDC_STATIC_CHANNEL_WINDOW_2, OnClickedChannelWindow2)
	ON_BN_CLICKED(IDC_STATIC_CHANNEL_WINDOW_3, OnClickedChannelWindow3)
	ON_BN_CLICKED(IDC_STATIC_CHANNEL_WINDOW_4, OnClickedChannelWindow4)
	ON_BN_CLICKED(IDC_STATIC_CHANNEL_WINDOW_5, OnClickedChannelWindow5)
	ON_BN_CLICKED(IDC_BUTTON_RECORD, OnButtonRecord)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg message handlers

extern CAnimationFactoryApp theApp;

void CAnimationFactoryDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	// UNINITIALIZE SHARE RECORDING
	//
	OnButtonStop();

	// UNINITIALIZE ANIMATION CLIP
	//
	for( ULONG i = 0 ; i < 2 ; i++ ) {

		if( m_pClips[ i ] ) {

			QCAP_STOP_ANIMATION_CLIP( m_pClips[ i ] );

			QCAP_DESTROY_ANIMATION_CLIP( m_pClips[ i ] );

			m_pClips[ i ] = NULL;
		}
	}

	// UNINITIALIZE DEVICE RESOURCE
	// 
	for( i = 0 ; i < 6 ; i++ ) {

		if( m_pDevices[ i ] ) {

			QCAP_STOP( m_pDevices[ i ] );

			QCAP_DESTROY( m_pDevices[ i ] );

			m_pDevices[ i ] = NULL;
		}
	}
	DeleteCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 0 ] );

	DeleteCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 1 ] );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

BOOL CAnimationFactoryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE DEVICE RESOURCE
	// 
	g_pAnimationFactoryDlg = this;

	for( ULONG i = 0 ; i < 6 ; i++ ) {
		
		m_pDevices[ i ] = NULL;

		m_nDeviceVideoWidths[ i ] = 0;

		m_nDeviceVideoHeights[ i ] = 0;

		m_nDeviceAudioChannels[ i ] = 0;

		m_nDeviceAudioBitsPerSamples[ i ] = 0;

		m_nDeviceAudioSampleFrequencys[ i ] = 0;
	}
	for( i = 0 ; i < 2 ; i++ ) {
		
		m_pClips[ i ] = NULL;

		m_iClipCurrentFrames[ i ] = 0;

		m_nClipFrames[ i ] = 0;

		m_nClipSprites[ i ] = 0;

		m_nClipColorSpaceTypes[ i ] = 0x00000000;

		m_nClipWidths[ i ] = 0;

		m_nClipHeights[ i ] = 0;
	}
	for( i = 0 ; i < 2 ; i++ ) {

		m_nShareRecordStates[ i ] = 0x00000000;

		m_hShareRecordThreadStopEvents[ i ] = NULL;

		m_hShareRecordThreadBufferReadyEvents[ i ] = NULL;

		m_hShareRecordThreads[ i ] = NULL;

		InitializeCriticalSection( &m_hShareRecordStateAccessCriticalSections[ i ] );
	}
	// INITIALIZE DEVICE RESOURCE
	// 
	QCAP_CREATE( "SA7160 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], TRUE );

	QCAP_CREATE( "SA7160 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], TRUE );

	QCAP_CREATE( "SA7160 PCI", 2, m_statChannelWindow2.m_hWnd, &m_pDevices[ 2 ], TRUE );

	QCAP_CREATE( "SA7160 PCI", 3, m_statChannelWindow3.m_hWnd, &m_pDevices[ 3 ], TRUE );

	QCAP_CREATE( "SA7160 PCI", 4, m_statChannelWindow4.m_hWnd, &m_pDevices[ 4 ], TRUE );

	QCAP_CREATE( "SA7160 PCI", 5, m_statChannelWindow5.m_hWnd, &m_pDevices[ 5 ], TRUE );

	for( i = 0 ; i < 6 ; i++ ) {

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevices[ i ], on_format_changed_callback, (PVOID)(i) );

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevices[ i ], on_no_signal_detected_callback, (PVOID)(i) );

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevices[ i ], on_no_signal_removed_callback, (PVOID)(i) );

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevices[ i ], on_video_preview_callback, (PVOID)(i) );

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevices[ i ], on_audio_preview_callback, (PVOID)(i) );

		QCAP_RUN( m_pDevices[ i ] );
	}

	// INITIALIZE ANIMATION RESOURCE
	// 
	for( i = 0 ; i < 2 ; i++ ) {

		QCAP_CREATE_ANIMATION_CLIP( "EXAMPLE.PIP.XML", &m_pClips[ i ], &m_nClipFrames[ i ], &m_nClipSprites[ i ], &m_nClipColorSpaceTypes[ i ], &m_nClipWidths[ i ], &m_nClipHeights[ i ] );

		if( m_pClips[ i ] == NULL ) {

			QCAP_CREATE_ANIMATION_CLIP( "..\\EXAMPLE.PIP.XML", &m_pClips[ i ], &m_nClipFrames[ i ], &m_nClipSprites[ i ], &m_nClipColorSpaceTypes[ i ], &m_nClipWidths[ i ], &m_nClipHeights[ i ] );
		}
		m_iClipCurrentFrames[ i ] = m_nClipFrames[ i ] - 1;
	}
	QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClips[ 0 ], 0, m_pDevices[ 0 ] );

	QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClips[ 0 ], 1, m_pDevices[ 1 ] );

	QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClips[ 1 ], 0, m_pDevices[ 0 ] );

	QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClips[ 1 ], 1, m_pDevices[ 1 ] );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAnimationFactoryDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAnimationFactoryDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAnimationFactoryDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAnimationFactoryDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CAnimationFactoryDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CAnimationFactoryDlg::OnClickedChannelWindow0() 
{
	// TODO: Add your control notification handler code here
}

void CAnimationFactoryDlg::OnClickedChannelWindow1() 
{
	// TODO: Add your control notification handler code here
}

void CAnimationFactoryDlg::OnClickedChannelWindow2() 
{
	// TODO: Add your control notification handler code here
}

void CAnimationFactoryDlg::OnClickedChannelWindow3() 
{
	// TODO: Add your control notification handler code here
}

void CAnimationFactoryDlg::OnClickedChannelWindow4() 
{
	// TODO: Add your control notification handler code here
}

void CAnimationFactoryDlg::OnClickedChannelWindow5() 
{
	// TODO: Add your control notification handler code here	
}

void CAnimationFactoryDlg::OnButtonRecord() 
{
	// TODO: Add your control notification handler code here
	
	m_hShareRecordThreadStopEvents[ 0 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThreadBufferReadyEvents[ 0 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThreadStopEvents[ 1 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThreadBufferReadyEvents[ 1 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThreads[ 0 ] = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_process_share_record_ch01), (LPVOID)(this), 0, NULL );

	m_hShareRecordThreads[ 1 ] = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_process_share_record_ch02), (LPVOID)(this), 0, NULL );

	QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, m_nClipColorSpaceTypes[ 0 ], m_nClipWidths[ 0 ], m_nClipHeights[ 0 ], 30, QCAP_RECORD_MODE_CBR, 8000, 12000000, 30, 0, 0, m_statShareWindow0.m_hWnd, TRUE, FALSE );

	QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, m_nClipColorSpaceTypes[ 1 ], m_nClipWidths[ 1 ], m_nClipHeights[ 1 ], 30, QCAP_RECORD_MODE_CBR, 8000, 12000000, 30, 0, 0, m_statShareWindow1.m_hWnd, TRUE, FALSE );

	QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000 );

	QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000 );

	QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( 0, on_video_share_record_media_timer_callback, (PVOID)0);

	QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( 1, on_video_share_record_media_timer_callback, (PVOID)1);

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	QCAP_SET_VIDEO_RECORD_PROPERTY( m_pDevices[ 0 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
	
	QCAP_SET_VIDEO_RECORD_PROPERTY( m_pDevices[ 1 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
	
	QCAP_SET_VIDEO_RECORD_PROPERTY( m_pDevices[ 2 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
	
	QCAP_SET_VIDEO_RECORD_PROPERTY( m_pDevices[ 3 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
	
	QCAP_SET_VIDEO_RECORD_PROPERTY( m_pDevices[ 4 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
	
	QCAP_SET_VIDEO_RECORD_PROPERTY( m_pDevices[ 5 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevices[ 0 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevices[ 1 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevices[ 2 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevices[ 3 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevices[ 4 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevices[ 5 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

	//////////////////////////////////////////////////////////////////////////////////////////////////////////

	QCAP_START_SHARE_RECORD( 0, "DEMO.01.MP4", QCAP_RECORD_FLAG_FULL | QCAP_RECORD_FLAG_VIDEO_USE_MEDIA_TIMER | QCAP_RECORD_FLAG_AUDIO_USE_MEDIA_TIMER );

	QCAP_START_SHARE_RECORD( 1, "DEMO.02.MP4", QCAP_RECORD_FLAG_FULL | QCAP_RECORD_FLAG_VIDEO_USE_MEDIA_TIMER | QCAP_RECORD_FLAG_AUDIO_USE_MEDIA_TIMER );

	QCAP_START_RECORD( m_pDevices[ 0 ], 0, "CH01.MP4" );

	QCAP_START_RECORD( m_pDevices[ 1 ], 0, "CH02.MP4" );

	QCAP_START_RECORD( m_pDevices[ 2 ], 0, "CH03.MP4" );

	QCAP_START_RECORD( m_pDevices[ 3 ], 0, "CH04.MP4" );

	QCAP_START_RECORD( m_pDevices[ 4 ], 0, "CH05.MP4" );

	QCAP_START_RECORD( m_pDevices[ 5 ], 0, "CH06.MP4" );

	Sleep( 30 );

	EnterCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 0 ] );

	m_nShareRecordStates[ 0 ] = 0x00000001;

	LeaveCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 0 ] );

	EnterCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 1 ] );

	m_nShareRecordStates[ 1 ] = 0x00000001;

	LeaveCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 1 ] );
}

void CAnimationFactoryDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here
	
	EnterCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 0 ] );

	m_nShareRecordStates[ 0 ] = 0x00000000;

	LeaveCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 0 ] );

	EnterCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 1 ] );

	m_nShareRecordStates[ 1 ] = 0x00000000;

	LeaveCriticalSection( &m_hShareRecordStateAccessCriticalSections[ 1 ] );

	Sleep( 30 );

	for( ULONG i = 0 ; i < 2 ; i++ ) {

		if( m_hShareRecordThreadStopEvents[ i ] ) { 
			
			SetEvent( m_hShareRecordThreadStopEvents[ i ] ); 
		}
		CLOSE_THREAD( m_hShareRecordThreads[ i ] );

		if( m_hShareRecordThreadStopEvents[ i ] != NULL ) {

			CloseHandle( m_hShareRecordThreadStopEvents[ i ] );

			m_hShareRecordThreadStopEvents[ i ] = NULL;
		}
		if( m_hShareRecordThreadBufferReadyEvents[ i ] != NULL ) {

			CloseHandle( m_hShareRecordThreadBufferReadyEvents[ i ] );

			m_hShareRecordThreadBufferReadyEvents[ i ] = NULL;
		}
	}
	QCAP_STOP_SHARE_RECORD( 0 );

	QCAP_STOP_SHARE_RECORD( 1 );

	QCAP_STOP_RECORD( m_pDevices[ 0 ], 0 );

	QCAP_STOP_RECORD( m_pDevices[ 1 ], 0 );

	QCAP_STOP_RECORD( m_pDevices[ 2 ], 0 );

	QCAP_STOP_RECORD( m_pDevices[ 3 ], 0 );

	QCAP_STOP_RECORD( m_pDevices[ 4 ], 0 );

	QCAP_STOP_RECORD( m_pDevices[ 5 ], 0 );
}
